<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: admin_login.php');
    exit;
}
$pdo = new PDO('mysql:host=localhost;dbname=nice_massage', 'root', '');
$bookings = $pdo->query("SELECT * FROM bookings ORDER BY created_at DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head><title>Admin Dashboard</title></head>
<body>
    <h1>Booking List</h1>
    <table border="1">
        <tr>
            <th>Name</th><th>Phone</th><th>Service</th><th>Duration</th>
            <th>Therapist</th><th>DateTime</th><th>Address</th><th>Created At</th>
        </tr>
        <?php foreach ($bookings as $b): ?>
        <tr>
            <td><?= htmlspecialchars($b['customer_name']) ?></td>
            <td><?= htmlspecialchars($b['customer_phone']) ?></td>
            <td><?= htmlspecialchars($b['service']) ?></td>
            <td><?= htmlspecialchars($b['duration_price']) ?></td>
            <td><?= htmlspecialchars($b['therapist_preference']) ?></td>
            <td><?= htmlspecialchars($b['booking_datetime']) ?></td>
            <td><?= htmlspecialchars($b['customer_address']) ?></td>
            <td><?= htmlspecialchars($b['created_at']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
    <p><a href="admin_logout.php">Logout</a></p>
</body>
</html>